% Caudal fin widefield quantification Matlab Script
% Date: 03/12/2021
% version: 1.0.0
% Telmo Pereira
% telmo.pereira@nms.unl.pt - CEDOC/Nova Medical School - NMS
% 
% Database file template:
% S(X).name = 'name';            %filename
% S(X).MinPeakDistance = number; % distance between peaks
% S(X).rays = [];                % rays to analyse
% S(X).loc = 100;                % start location
% S(X).corrected = [];           % manual data curation : identified peaks are ignored/removed : format [ray peak; ray2 peak2; ..]
% S(X).z_bf = 16;                % Z position of the brightfield image

%% Open image widefield
clearvars -except S
filepath = ''; %filepath
results=[];

% Database number
M = [];

% Show of hide images
show = 0;
for batch = 1:length(M)
    N=M(batch);
    
    if N< 50
        type = 1; %conditions
    else
        type = 0; %controls
    end
    
    files = S(N).name;
    Img = openimg([filepath files '.tif']);
    InfoImage=imfinfo([filepath files '.tif']);
    C1 = Img(:,:,1:2:end);
    C2 = Img(:,:,2:2:end);
    Img_channels = cat(4,C1,C2);

    % Open lines file
    Datapoints = readmatrix([filepath files '.csv']);
    Datapoints1 = Datapoints(1:2:end,2:3);
    Datapoints2 = Datapoints(2:2:end,2:3);
    Datapoints_xy = cat(3,Datapoints1,Datapoints2) .* InfoImage(1).XResolution; %in pixel coordinates

    cMap = interp1([0;1],[0 0 0; 0 1 0],linspace(0,1,256));
    
    %Image preparation
    Img_test1 = max(Img_channels,[],3); %gfp
    Img_test1 = Img_test1(:,:,:,1); %gfp max proj
    Img_test2 = Img_channels(:,:,S(N).z_bf,2); %BF
    Img_gauss1 = imgaussfilt(Img_test1,10);
    Img_gauss2 = imgaussfilt(Img_test2,2);
    
    % Show images
    if show
        h1 = imshow(imadjust(Img_test1));
        hold on
        h=imshow(ind2rgb(im2uint8((imadjust(Img_gauss1))),cMap));
        set(h, 'AlphaData', 1);
        set(h1, 'AlphaData', 0);
    end
    
    % Main cycle initialization
    locations = zeros(size(Datapoints1,1),10);
    aux=[];
    for i=S(N).rays
        
        %Image profiles
        [cx1,cy1,prof1{i}] = improfile(Img_gauss1,[Datapoints_xy(i,1,1) Datapoints_xy(i,1,2)],[Datapoints_xy(i,2,1) Datapoints_xy(i,2,2)]);
        [cx2,cy2,prof2{i}] = improfile(Img_gauss2,[Datapoints_xy(i,1,1) Datapoints_xy(i,1,2)],[Datapoints_xy(i,2,1) Datapoints_xy(i,2,2)]);
        idx = find(prof1{i}>mean(prof1{i}(1:10,1))*2,1,'first');
        
        if show
            plot(cx1(idx),cy1(idx),'m*')
            plot(Datapoints_xy(i,1,1),Datapoints_xy(i,2,1),'r*')
            plot(Datapoints_xy(i,1,2),Datapoints_xy(i,2,2),'g*')
        end
        
        % Finding peaks
        [peaks,loc] = findpeaks(-prof2{i},'MinPeakDistance', S(N).MinPeakDistance,'MaxPeakWidth',50,'Threshold',0);

        loc(loc< S(N).loc) = [];
        % Manual Corrections
        for cor = 1:size(S(N).corrected,1)
            if S(N).corrected(cor,1) == i
                loc(S(N).corrected(cor,2)) = [];
            end
        end

        locations(i,1:length(loc)+1) = [idx;loc];
        if show
            for u=1:length(loc)
                plot(cx2(loc(u)),cy2(loc(u)),'c*')
            end
        end
         
        thresh = 500;
        prof3 = prof1{i};
        prof3(prof3<=thresh) = 0;
        prof3(prof3>thresh) = 1;
        
        % Data processing for 1st and 2nd bone segment
        for m = 1:2
            a1= cumsum((prof1{i}(locations(i,m):locations(i,m+1),1)));
            a2= cumsum((prof3(locations(i,m):locations(i,m+1),1)));
            center_idx = find(a1>a1(end)/2,1);
            center_idx2 = find(a2>a2(end)/2,1);
            if show
                plot(cx2(locations(i,m)+center_idx),cy2(locations(i,m)+center_idx),'yo')
                plot(cx2(locations(i,m)+center_idx2),cy2(locations(i,m)+center_idx2),'mo')
            end
            aux(m,:) = [locations(i,m+1)-locations(i,m) 1-(center_idx/(locations(i,m+1)-locations(i,m)))];
            aux2(m,:) = [locations(i,m+1)-locations(i,m) 1-(center_idx2/(locations(i,m+1)-locations(i,m)))];
        end
        aux1 = [type N i aux(1,1)./InfoImage(1).XResolution aux(2,1)./InfoImage(1).XResolution aux(1,2) aux(2,2) aux2(1,2) aux2(2,2)];
        results = cat(1,results,aux1);
        aux=[];
    end
    if show
        hold off
    end
end